package com.atlassian.bitbucket.event.repository;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a repository is accessed for read but <i>not</i> {@link RepositoryPullEvent pulling refs}.
 * <p>
 * Some SCMs may have multi-step processing for pull operations, such as the ref negotiation phase of a
 * {@code git clone}, {@code git fetch} or {@code git pull}. This event should be raised for preliminary
 * requests leading up to the {@link RepositoryPullEvent pull}. Some SCM implementations may not raise this event.
 * <p>
 * This event is internally audited with a LOW priority.
 */
@AsynchronousPreferred
public class RepositoryOtherReadEvent extends RepositoryEvent {

    public RepositoryOtherReadEvent(@Nonnull Object source, @Nonnull Repository repository) {
        super(source, repository);
    }
}
