package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a rescope activity is created for a pull request.
 */
@AsynchronousPreferred
public class PullRequestRescopeActivityEvent extends PullRequestActivityEvent {

    public PullRequestRescopeActivityEvent(@Nonnull Object source, @Nonnull PullRequestRescopeActivity activity) {
        super(source, activity);
    }

    @Nonnull
    @Override
    public PullRequestRescopeActivity getActivity() {
        return (PullRequestRescopeActivity) super.getActivity();
    }
}
