package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when a pull request is opened.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.opened")
public class PullRequestOpenedEvent extends PullRequestEvent {

    public PullRequestOpenedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        super(source, pullRequest, PullRequestAction.OPENED);
    }
}
