package com.atlassian.bitbucket.event.pull;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event that is raised when a comment is edited on a pull request.
 */
@AsynchronousPreferred
@EventName("stash.pullrequest.comment.edited")
public class PullRequestCommentEditedEvent extends PullRequestCommentEvent {

    private final String previousText;

    public PullRequestCommentEditedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest,
                                         @Nonnull Comment comment, @Nullable Comment parent,
                                         @Nonnull String previousText) {
        super(source, pullRequest, comment, parent, CommentAction.EDITED);

        this.previousText = checkNotNull(previousText, "previousText");
    }

    @Nonnull
    public String getPreviousText() {
        return previousText;
    }
}
