package com.atlassian.bitbucket.event.project;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Raised when a {@link Project project's} avatar is updated.
 * <p>
 * This event is internally audited with a LOW priority.
 *
 * @see ProjectService#updateAvatar
 */
@AsynchronousPreferred
@EventName("stash.project.avatar.updated")
public class ProjectAvatarUpdatedEvent extends ProjectEvent {

    public ProjectAvatarUpdatedEvent(@Nonnull Object source, @Nonnull Project project) {
        super(source, project);
    }
}
