package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;

/**
 * This event is fired when a user or group has their permission modified for a given repository.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
public class RepositoryPermissionModifiedEvent extends AbstractRepositoryPermissionModificationEvent implements PermissionModifiedEvent {

    public RepositoryPermissionModifiedEvent(Object source,
                                             Permission oldValue, Permission newValue,
                                             Repository repository,
                                             String affectedGroup, ApplicationUser affectedUser) {
        super(source, oldValue, newValue, repository, affectedGroup, affectedUser);
    }
}
