package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Event signalling project permission changes.
 */
public abstract class ProjectPermissionEvent extends PermissionEvent {

    private final Project project;

    protected ProjectPermissionEvent(Object source, Permission permission, Project project,
                                     String affectedGroup, ApplicationUser affectedUser) {

        super(source, permission, affectedGroup, affectedUser);

        checkArgument(permission.isResource(Project.class), "Require a project permission");
        this.project = checkNotNull(project, "project");
    }

    @Nonnull
    public Project getProject() {
        return project;
    }
}
