package com.atlassian.bitbucket.event.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * An event which is fired when a user or group has their permission modified.
 *
 * @see GlobalPermissionModifiedEvent
 * @see ProjectPermissionModifiedEvent
 * @see RepositoryPermissionModifiedEvent
 */
public interface PermissionModifiedEvent {

    /**
     * @return the affected group of {@code null} if a user was affected
     */
    @Nullable
    String getAffectedGroup();

    /**
     * @return the affected user of {@code null} if a group was affected
     */
    @Nullable
    ApplicationUser getAffectedUser();

    /**
     * @return the new permission which replaced the previous value
     */
    @Nonnull
    Permission getNewValue();

    /**
     * @return the old permission which was replaced
     */
    @Nonnull
    Permission getOldValue();

}
