package com.atlassian.bitbucket.event.mirror;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.collect.ImmutableList;

import javax.annotation.Nonnull;
import java.util.Collection;

import static java.util.Objects.requireNonNull;

/**
 * This event signals that a {@link Repository} has been synchronized on a mirror
 *
 * @since 5.0
 */
public class RepositoryMirrorSynchronizedEvent extends AbstractRepositoryMirrorEvent {

    private final Collection<MinimalRef> failedRefs;
    private final Collection<RefChange> refChanges;

    public RepositoryMirrorSynchronizedEvent(@Nonnull Object source, @Nonnull String mirrorServerId,
                                             @Nonnull Repository repository,
                                             @Nonnull Collection<MinimalRef> failedRefs,
                                             @Nonnull Collection<RefChange> refChanges) {
        super(source, mirrorServerId, repository);
        this.failedRefs = ImmutableList.copyOf(requireNonNull(failedRefs, "failedRefs"));
        this.refChanges = ImmutableList.copyOf(requireNonNull(refChanges, "refChanges"));
    }

    /**
     * @return a collection of refs which failed to update on the mirror
     */
    @Nonnull
    public Collection<MinimalRef> getFailedRefs() {
        return failedRefs;
    }

    /**
     * @return a collection of refs successfully updated on the mirror
     */
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return refChanges;
    }
}