package com.atlassian.bitbucket.event.license;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.event.api.AsynchronousPreferred;

import javax.annotation.Nonnull;

/**
 * Event that is raised when the license is changed.
 * <p>
 * This event is internally audited with a HIGH priority.
 */
@AsynchronousPreferred
@TransactionAware
public class LicenseChangedEvent extends ApplicationEvent {

    public LicenseChangedEvent(@Nonnull Object source) {
        super(source);
    }
}
