package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.scm.ScmCommandFactory;

import javax.annotation.Nonnull;
import java.util.OptionalLong;

/**
 * Represents a file in a source tree.
 */
public abstract class File implements ContentTreeNode {

    /**
     * Retrieves the size of the file, if sizes were requested.
     * <p>
     * For performance reasons, file sizes are not retrieved by default. If they are requested, the returned
     * {@code OptionalLong} will be set with the file's size. Otherwise, it will be {@code empty()}.
     * <p>
     * When using {@link ContentService#streamDirectory}, file sizes will be returned for <i>non-recursive</i>
     * requests. When using {@link ScmCommandFactory#directory)} directly, file sizes can be requested or not
     * by setting {@link com.atlassian.bitbucket.scm.DirectoryCommandParameters.Builder#withSizes(boolean)}.
     *
     * @return the size, if requested, or {@code empty()}
     * @since 4.2
     */
    @Nonnull
    public abstract OptionalLong getSize();

    /**
     * @return {@link Type#FILE}
     */
    @Nonnull
    @Override
    public Type getType() {
        return Type.FILE;
    }
}
