package com.atlassian.bitbucket.concurrent;

import javax.annotation.Nonnull;
import java.util.concurrent.locks.Lock;

/**
 * Provides various types of locks, all of which are safe to use in a cluster.
 */
public interface LockService {

    /**
     * Creates or retrieves a {@link Lock} by name
     *
     * @param lockName the name of the lock
     * @return the lock
     */
    @Nonnull
    Lock getLock(@Nonnull String lockName);

    /**
     * Creates or retrieves a {@link PullRequestLock} by name
     *
     * @param lockName the name of the lock
     * @return the pull request lock
     */
    @Nonnull
    PullRequestLock getPullRequestLock(@Nonnull String lockName);

    /**
     * Creates or retrieves a {@link RepositoryLock} by name
     *
     * @param lockName the name of the lock
     * @return the repository lock
     */
    @Nonnull
    RepositoryLock getRepositoryLock(@Nonnull String lockName);
}
