package com.atlassian.bitbucket.concurrent;

import javax.annotation.Nonnull;
import java.io.Serializable;

public interface ConcurrencyService {

    /**
     * Retrieves a {@link BucketedExecutor} by name, or creates a new one if it does not already exists.
     *
     * @param name     the executor name
     * @param settings configuration for the executor
     * @return the executor, or {@code null} if it hasn't been created yet.
     */
    @Nonnull
    <T extends Serializable> BucketedExecutor<T> getBucketedExecutor(@Nonnull String name,
                                                                     @Nonnull BucketedExecutorSettings<T> settings);
}
