package com.atlassian.bitbucket.concurrent;

/**
 * Policy for concurrency limits
 */
public enum ConcurrencyPolicy {
    /**
     * Denotes that concurrency limits apply at the cluster level. A concurrency limit of 2 PER_CLUSTER means that
     * up to 2 processes can be executed concurrently across the cluster.
     */
    PER_CLUSTER,
    /**
     * Denotes that concurrency limits apply at the node level. A concurrency limit of 2 PER_NODE means that up to 2
     * processes can be executed concurrently on _each_ node in the cluster.
     */
    PER_NODE
}
