package com.atlassian.bitbucket.compare;

import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Repository;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkNotNull;

/**
 * A ref or commit to compare.
 *
 * @see CompareRequest
 * @see CompareDiffRequest
 */
public class CompareRef {

    private final String id;
    private final Repository repository;

    public CompareRef(@Nonnull String id, @Nonnull Repository repository) {
        checkArgument(StringUtils.isNotBlank(id), "An non-blank id is required");
        checkNotNull(repository, "repository");

        this.id = id;
        this.repository = repository;
    }

    /**
     * Convenience constructor for creating a {@code CompareRef} from a {@link PullRequestRef}.
     *
     * @param ref the pull request ref to create a compare ref from
     */
    public CompareRef(@Nonnull PullRequestRef ref) {
        this(checkNotNull(ref, "ref").getId(), ref.getRepository());
    }

    /**
     * @return a ref name or a commit ID
     */
    @Nonnull
    public String getId() {
        return id;
    }

    /**
     * @return the repository containing the ref or commit
     */
    @Nonnull
    public Repository getRepository() {
        return repository;
    }
}
