package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;

import javax.annotation.Nonnull;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

/**
 * A simple implementation of {@link MinimalRepositoryCommit}.
 *
 * @since 5.8
 */
public class SimpleMinimalRepositoryCommit extends SimpleMinimalCommit implements MinimalRepositoryCommit {

    private final Repository repository;

    private SimpleMinimalRepositoryCommit(Builder builder) {
        super(builder);

        repository = requireNonNull(builder.repository, "repository");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleMinimalRepositoryCommit) {
            SimpleMinimalRepositoryCommit that = (SimpleMinimalRepositoryCommit) o;

            return Objects.equals(that.getId(), getId()) &&
                    Objects.equals(that.getRepository(), getRepository());
        }
        return false;
    }

    @Nonnull
    @Override
    public Repository getRepository() {
        return repository;
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId(), getRepository());
    }

    @Override
    public String toString() {
        return "SimpleMinimalRepositoryCommit{" +
                "id='" + getId() + "', " +
                "repository=" + repository +
                '}';
    }

    public static final class Builder extends AbstractMinimalCommitBuilder<Builder, SimpleMinimalRepositoryCommit> {

        private Repository repository;

        public Builder(@Nonnull String id) {
            super(id);
        }

        @Nonnull
        public SimpleMinimalRepositoryCommit build() {
            return new SimpleMinimalRepositoryCommit(this);
        }

        @Nonnull
        public Builder repository(@Nonnull Repository value) {
            repository = requireNonNull(value, "repository");

            return self();
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
