package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.AbstractSummary;

import javax.annotation.Nonnull;

public class CommitSummary extends AbstractSummary {

    private CommitSummary(Builder builder) {
        super(builder);
    }

    public static class Builder extends AbstractBuilder<Builder, CommitSummary> {

        /**
         * Creates and initializes a new builder by copying details from the provided {@link CommitSummary summary}.
         *
         * @param summary the summary to initialize this builder from
         */
        public Builder(@Nonnull AbstractSummary summary) {
            super(summary);
        }

        /**
         * Creates a new builder with the provided {@link CommandResult result}.
         *
         * @param result the operation result for the summary
         */
        public Builder(@Nonnull CommandResult result) {
            super(result);
        }

        @Nonnull
        @Override
        public CommitSummary build() {
            return new CommitSummary(this);
        }

        @Nonnull
        @Override
        protected Builder self() {
            return this;
        }
    }
}
