package com.atlassian.bitbucket.commit;

import javax.annotation.Nonnull;
import java.io.IOException;

/**
 * Convenience implementation of {@link CommitCallback} that provides no-op implementations for all methods.
 */
public abstract class AbstractCommitCallback implements CommitCallback {

    /**
     * @param commit ignored
     * @return {@code true}
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public boolean onCommit(@Nonnull Commit commit) throws IOException {
        return true;
    }

    /**
     * @param summary ignored
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public void onEnd(@Nonnull CommitSummary summary) throws IOException {
    }

    /**
     * @param context ignored
     * @throws IOException may be thrown by derived classes
     */
    @Override
    public void onStart(@Nonnull CommitContext context) throws IOException {
    }
}
