package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;

/**
 * Entity that users can comment on.
 */
public interface Commentable {

    /**
     * Accepts the provided {@link CommentableVisitor visitor} and invokes the appropriate {@code visit} overload
     * for this commentable type, returning its result.
     * <p>
     * Note: Nullability for the return value is intentionally not documented one way or another. It is expected that
     * the <i>caller</i> will know the nullability of the visitor implementation they are passing and code accordingly.
     *
     * @param visitor the visitor to invoke
     * @return the result of the invoked {@code visit} method
     */
    <T> T accept(@Nonnull CommentableVisitor<T> visitor);
}
