package com.atlassian.bitbucket.comment;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

/**
 * A request for making changes to a {@link Comment comment}
 *
 * @since 5.0
 */
public class CommentUpdateRequest {

    private final long commentId;
    private final String text;
    private final int version;

    private CommentUpdateRequest(@Nonnull Builder builder) {
        commentId = builder.commentId;
        text = requireNonNull(builder.text, "text");
        version = builder.version;
    }

    public long getCommentId() {
        return commentId;
    }

    @Nonnull
    public String getText() {
        return text;
    }

    public int getVersion() {
        return version;
    }

    public static class Builder {

        private final long commentId;

        private String text;
        private int version;

        public Builder(long commentId) {
            this.commentId = commentId;
        }

        @Nonnull
        public CommentUpdateRequest build() {
            return new CommentUpdateRequest(this);
        }

        @Nonnull
        public Builder text(@Nonnull String value) {
            text = value;
            return this;
        }

        @Nonnull
        public Builder version(int value) {
            version = value;
            return this;
        }
    }
}
