package com.atlassian.bitbucket.cluster;

import javax.annotation.Nonnull;

/**
 * Provides access to cluster details for the instance.
 */
public interface ClusterService {

    /**
     * @return details about the cluster and its {@link ClusterNode nodes}
     */
    @Nonnull
    ClusterInformation getInformation();

    /**
     * Convenience method for obtaining the ID for the local node. Calling the method is equivalent to calling
     * {@code getInformation().getLocalNode().getId()}
     *
     * @return the ID of the local node
     */
    @Nonnull
    String getNodeId();

    /**
     * @return {@code true} if clustering is available; otherwise, {@code false}
     */
    boolean isAvailable();

    /**
     * @return {@code true} if clustering is {@link #isAvailable() available} <i>and</i> at least two nodes have
     *         joined the cluster
     */
    boolean isClustered();
}
