package com.atlassian.bitbucket.cluster;

import javax.annotation.Nonnull;
import java.util.Set;

/**
 * Describes a cluster, providing details about each node.
 */
public interface ClusterInformation {

    /**
     * @return information about the local node
     */
    @Nonnull
    ClusterNode getLocalNode();

    /**
     * @return a set describing all of the nodes in the cluster, which will always contain at least one node
     */
    @Nonnull
    Set<ClusterNode> getNodes();

    /**
     * @return {@code true} if the clustering services are running, indicating nodes can join the cluster;
     *         otherwise, {@code false} if clustering services are not running
     */
    boolean isRunning();
}
