package com.atlassian.bitbucket.auth;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.user.UserService;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Base type for all exceptions which are thrown while processing user authentication attempts.
 * <p>
 * This base type is provided to stem the authentication exception hierarchy. However, it will usually not be
 * desirable to process exceptions at this level. Instead, callers are encouraged to catch specific exception
 * types where they wish to handle failures.
 *
 * @see UserService#authenticate(String, String)
 * @see UserService#updatePassword(String, String)
 */
public abstract class AuthenticationException extends ServiceException {

    public AuthenticationException(@Nonnull KeyedMessage message) {
        super(message);
    }

    public AuthenticationException(@Nonnull KeyedMessage message, @Nullable Throwable cause) {
        super(message, cause);
    }
}
