/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm;

import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitListMergeFilter;
import com.atlassian.bitbucket.commit.CommitOrder;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.commit.CommitsRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitsCommandParameters
extends AbstractCommandParameters {
    private final boolean all;
    private final Set<String> excludes;
    private final boolean followRenames;
    private final boolean ignoringMissing;
    private final Set<String> includes;
    private final int maxMessageLength;
    private final CommitListMergeFilter merges;
    private final CommitOrder order;
    private final Set<String> paths;
    private final Repository secondaryRepository;
    private final boolean traversing;
    private final boolean withMessages;

    private CommitsCommandParameters(Builder builder) {
        this.all = builder.all;
        this.excludes = builder.traversing ? builder.excludes.build() : Collections.emptySet();
        this.followRenames = builder.followRenames;
        this.ignoringMissing = builder.ignoringMissing;
        this.includes = this.all ? Collections.emptySet() : builder.includes.build();
        this.maxMessageLength = builder.maxMessageLength;
        this.merges = builder.merges;
        this.order = builder.order;
        this.paths = builder.paths.build();
        this.secondaryRepository = builder.secondaryRepository;
        this.traversing = builder.traversing;
        boolean bl = this.withMessages = builder.withMessages && this.maxMessageLength != 0;
        if (this.followRenames) {
            if (this.paths.isEmpty()) {
                throw new IllegalStateException("A path must be supplied when attempting to follow renames");
            }
            if (this.paths.size() > 1) {
                throw new IllegalStateException("Following renames is only possible with a single path");
            }
        }
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public CommitListMergeFilter getMerges() {
        return this.merges;
    }

    @Nonnull
    public CommitOrder getOrder() {
        return this.order;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public boolean hasExcludes() {
        return !this.excludes.isEmpty();
    }

    public boolean hasIncludes() {
        return !this.includes.isEmpty();
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    public boolean hasSecondaryRepository() {
        return this.secondaryRepository != null;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isFollowingRenames() {
        return this.followRenames;
    }

    public boolean isIgnoringMissing() {
        return this.ignoringMissing;
    }

    public boolean isTraversing() {
        return this.traversing;
    }

    public boolean isWithMessages() {
        return this.withMessages;
    }

    @Nonnull
    public CommitContext toContext() {
        return new CommitContext.Builder().build();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> paths;
        private boolean all;
        private boolean followRenames;
        private boolean ignoringMissing;
        private int maxMessageLength = -1;
        private CommitListMergeFilter merges = CommitListMergeFilter.INCLUDE;
        private CommitOrder order = CommitOrder.DEFAULT;
        private Repository secondaryRepository;
        private boolean traversing = true;
        private boolean withMessages = true;

        public Builder() {
            this.paths = ImmutableSet.builder();
        }

        public Builder(@Nonnull CommitsBetweenRequest request) {
            this();
            this.exclude(Objects.requireNonNull(request, "request").getExcludes()).followRenames(request.isFollowingRenames()).ignoreMissing(request.isIgnoringMissing()).include(request.getIncludes()).maxMessageLength(request.getMaxMessageLength()).merges(request.getMerges()).order(request.getOrder()).paths(request.getPaths()).secondaryRepository(request.getSecondaryRepository());
        }

        public Builder(@Nonnull CommitsRequest request) {
            this();
            this.followRenames(Objects.requireNonNull(request, "request").isFollowingRenames()).ignoreMissing(request.isIgnoringMissing()).include(request.getCommitId(), new String[0]).maxMessageLength(request.getMaxMessageLength()).merges(request.getMerges()).order(request.getOrder()).paths(request.getPaths());
        }

        @Nonnull
        public Builder all(boolean value) {
            this.all = value;
            return this;
        }

        @Nonnull
        public CommitsCommandParameters build() {
            return new CommitsCommandParameters(this);
        }

        @Nonnull
        public Builder exclude(@Nullable Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.excludes, values);
            return this;
        }

        @Nonnull
        public Builder exclude(@Nullable String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.excludes, value, values);
            return this;
        }

        @Nonnull
        public Builder followRenames(boolean value) {
            this.followRenames = value;
            return this;
        }

        @Nonnull
        public Builder ignoreMissing(boolean value) {
            this.ignoringMissing = value;
            return this;
        }

        @Nonnull
        public Builder include(@Nullable Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        @Nonnull
        public Builder include(@Nullable String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Nonnull
        public Builder merges(@Nonnull CommitListMergeFilter value) {
            this.merges = Objects.requireNonNull(value, "merges");
            return this;
        }

        @Nonnull
        public Builder order(@Nonnull CommitOrder value) {
            this.order = Objects.requireNonNull(value, "order");
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder secondaryRepository(@Nullable Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        @Nonnull
        public Builder traverse(boolean value) {
            this.traversing = value;
            return this;
        }

        @Nonnull
        public Builder withMessages(boolean value) {
            this.withMessages = value;
            return this;
        }
    }
}

