/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.comment;

import com.atlassian.bitbucket.comment.AddFileCommentRequest;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.comment.Commentable;
import com.atlassian.bitbucket.content.DiffFileType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class AddLineCommentRequest
extends AddFileCommentRequest {
    private final DiffFileType fileType;
    private final int line;
    private final DiffSegmentType lineType;

    private AddLineCommentRequest(Builder builder) {
        super(builder);
        Preconditions.checkArgument((builder.line != 0 ? 1 : 0) != 0, (Object)"line");
        this.fileType = (DiffFileType)((Object)Preconditions.checkNotNull((Object)((Object)builder.fileType), (Object)"fileType"));
        this.line = builder.line;
        this.lineType = (DiffSegmentType)((Object)Preconditions.checkNotNull((Object)((Object)builder.lineType), (Object)"lineType"));
    }

    @Nonnull
    public DiffFileType getFileType() {
        return this.fileType;
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public DiffSegmentType getLineType() {
        return this.lineType;
    }

    public static class Builder
    extends AddFileCommentRequest.AbstractFileBuilder<Builder, AddLineCommentRequest> {
        private int line = 0;
        private DiffSegmentType lineType;
        private DiffFileType fileType;

        public Builder(@Nonnull Commentable commentable, @Nonnull String text, @Nonnull CommentThreadDiffAnchorType diffType, @Nonnull String path) {
            super(commentable, text, diffType, path);
        }

        @Override
        @Nonnull
        public AddLineCommentRequest build() {
            return new AddLineCommentRequest(this);
        }

        @Nonnull
        public Builder fileType(@Nonnull DiffFileType value) {
            this.fileType = (DiffFileType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"fileType"));
            return this;
        }

        @Nonnull
        public Builder line(int value) {
            Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (String)"Line must be > %s (Rejected: %s)", (Object[])new Object[]{0, value});
            this.line = value;
            return this;
        }

        @Nonnull
        public Builder lineType(@Nonnull DiffSegmentType value) {
            this.lineType = (DiffSegmentType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"lineType"));
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

