/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.commit;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CommitsRequest {
    public static final int UNLIMITED_MESSAGE_SIZE = -1;
    private final String commitId;
    private final boolean followRenames;
    private final Boolean ignoringMissing;
    private final int maxMessageLength;
    private final Set<String> paths;
    private final Set<String> propertyKeys;
    private final Repository repository;

    private CommitsRequest(Builder builder) {
        this.commitId = builder.commitId;
        this.followRenames = builder.followRenames;
        this.ignoringMissing = builder.ignoreMissing;
        this.paths = builder.paths.build();
        this.propertyKeys = builder.propertyKeys.build();
        this.maxMessageLength = builder.maxMessageLength;
        this.repository = builder.repository;
        if (this.followRenames) {
            if (this.paths.isEmpty()) {
                throw new IllegalStateException("A path must be supplied when attempting to follow renames");
            }
            if (this.paths.size() > 1) {
                throw new IllegalStateException("Following renames is only possible with a single path");
            }
        }
    }

    @Nonnull
    public String getCommitId() {
        return this.commitId;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.propertyKeys;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public boolean isFollowingRenames() {
        return this.followRenames;
    }

    @Deprecated
    public Boolean isIgnoringMissing() {
        return this.ignoringMissing;
    }

    public static class Builder
    extends BuilderSupport {
        private final String commitId;
        private final ImmutableSet.Builder<String> paths;
        private final ImmutableSet.Builder<String> propertyKeys;
        private final Repository repository;
        private boolean followRenames;
        private Boolean ignoreMissing;
        private int maxMessageLength;

        public Builder(@Nonnull Repository repository, @Nonnull String commitId) {
            this.commitId = Builder.checkNotBlank(commitId, "commitId");
            this.repository = Objects.requireNonNull(repository, "repository");
            this.paths = ImmutableSet.builder();
            this.propertyKeys = ImmutableSet.builder();
            this.maxMessageLength = -1;
        }

        @Nonnull
        public CommitsRequest build() {
            return new CommitsRequest(this);
        }

        @Nonnull
        public Builder followRenames(boolean value) {
            this.followRenames = value;
            return this;
        }

        @Nonnull
        public Builder maxMessageLength(int value) {
            this.maxMessageLength = value;
            return this;
        }

        @Deprecated
        public Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        @Nonnull
        public Builder propertyKey(@Nullable String value) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable String value, String ... values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, value, values);
            return this;
        }

        @Nonnull
        public Builder propertyKeys(@Nullable Iterable<String> values) {
            Builder.addIf(NOT_BLANK, this.propertyKeys, values);
            return this;
        }
    }
}

