/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.event.pull;

import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.event.api.AsynchronousPreferred;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@AsynchronousPreferred
public class PullRequestMergedEvent
extends PullRequestEvent
implements RepositoryRefsChangedEvent {
    private final MinimalCommit commit;
    private final Map<String, Object> context;
    private final String message;
    private final Collection<RefChange> refChanges;

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest) {
        this(source, pullRequest, null, null, Collections.emptyMap());
    }

    public PullRequestMergedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nullable MinimalCommit commit, @Nullable String message, @Nonnull Map<String, Object> context) {
        super(source, pullRequest, PullRequestAction.MERGED);
        this.commit = commit;
        this.context = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(context, (Object)"context")));
        this.message = message;
        this.refChanges = commit == null ? Collections.emptyList() : Collections.singleton(new SimpleRefChange.Builder().from(pullRequest.getToRef()).toHash(commit.getId()).type(RefChangeType.UPDATE).build());
    }

    @Nullable
    public MinimalCommit getCommit() {
        return this.commit;
    }

    @Nonnull
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @Nonnull
    public Collection<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.getPullRequest().getToRef().getRepository();
    }

    public boolean isMergedRemotely() {
        return this.commit == null;
    }
}

