/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.AbstractDiffRequest;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DiffRequest
extends AbstractDiffRequest {
    private final Repository repository;
    private final String sinceId;
    private final String untilId;
    private final boolean withComments;

    private DiffRequest(Builder builder) {
        super(builder);
        this.repository = builder.repository;
        this.sinceId = builder.sinceId;
        this.untilId = builder.untilId;
        this.withComments = builder.withComments;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nullable
    public String getSinceId() {
        return this.sinceId;
    }

    @Nonnull
    public String getUntilId() {
        return this.untilId;
    }

    public boolean isWithComments() {
        return this.withComments;
    }

    public static class Builder
    extends AbstractDiffRequest.AbstractBuilder<Builder, DiffRequest> {
        private final Repository repository;
        private final String untilId;
        private String sinceId;
        private boolean withComments;

        public Builder(@Nonnull DiffRequest request) {
            super(request);
            this.repository = (Repository)Preconditions.checkNotNull((Object)request.getRepository(), (Object)"request.repository");
            this.sinceId = StringUtils.trimToNull((String)request.getSinceId());
            this.untilId = (String)Preconditions.checkNotNull((Object)request.getUntilId(), (Object)"request.untilId");
            this.withComments = request.isWithComments();
        }

        public Builder(@Nonnull Repository repository, @Nonnull String untilId) {
            Preconditions.checkNotNull((Object)untilId, (Object)"untilId");
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)untilId), (Object)"An \"until\" ID is required to stream a diff");
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
            this.untilId = untilId;
            this.withComments = true;
        }

        @Override
        @Nonnull
        public DiffRequest build() {
            return new DiffRequest(this);
        }

        @Override
        @Nonnull
        public Builder contextLines(int value) {
            return (Builder)super.contextLines(value);
        }

        @Nonnull
        public Builder sinceId(@Nullable String value) {
            this.sinceId = StringUtils.trimToNull((String)value);
            return this.self();
        }

        @Override
        @Nonnull
        public Builder path(@Nullable String value) {
            return (Builder)super.path(value);
        }

        @Override
        @Nonnull
        public Builder paths(@Nullable Iterable<String> values) {
            return (Builder)super.paths(values);
        }

        @Override
        @Nonnull
        public Builder paths(@Nullable String value, String ... values) {
            return (Builder)super.paths(value, values);
        }

        @Override
        @Nonnull
        public Builder whitespace(@Nonnull DiffWhitespace value) {
            return (Builder)super.whitespace(value);
        }

        @Nonnull
        public Builder withComments(boolean value) {
            this.withComments = value;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

