/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.mirror;

import com.atlassian.bitbucket.scm.AbstractCommandParameters;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nonnull;

public class MirrorSyncCommandParameters
extends AbstractCommandParameters {
    private final Optional<File> privateKeyFile;
    private final String remoteUrl;

    private MirrorSyncCommandParameters(Builder builder) {
        this.privateKeyFile = Optional.ofNullable(builder.privateKeyFile);
        this.remoteUrl = builder.remoteUrl;
    }

    @Nonnull
    public Optional<File> getPrivateKey() {
        return this.privateKeyFile;
    }

    @Nonnull
    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public static class Builder {
        private final String remoteUrl;
        private File privateKeyFile;

        public Builder(@Nonnull String remoteUrl) {
            this.remoteUrl = (String)Preconditions.checkNotNull((Object)remoteUrl, (Object)"remoteUrl");
        }

        @Nonnull
        public MirrorSyncCommandParameters build() {
            return new MirrorSyncCommandParameters(this);
        }

        @Nonnull
        public Builder privateKey(@Nonnull File value) {
            this.privateKeyFile = (File)Preconditions.checkNotNull((Object)value, (Object)"privateKeyFile");
            return this;
        }
    }
}

