/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.markup;

import com.atlassian.bitbucket.markup.UrlMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class RenderContext {
    private final Boolean hardwrap;
    private final Boolean htmlEscaped;
    private final UrlMode urlMode;
    private final Map<String, Object> data;

    private RenderContext(Builder builder) {
        this.hardwrap = builder.hardwrap;
        this.htmlEscaped = builder.htmlEscaped;
        this.urlMode = builder.urlMode;
        this.data = builder.dataBuilder.build();
    }

    @Nonnull
    public Map<String, Object> getData() {
        return this.data;
    }

    public Boolean getHardwrap() {
        return this.hardwrap;
    }

    public Boolean getHtmlEscaped() {
        return this.htmlEscaped;
    }

    @Nonnull
    public UrlMode getUrlMode() {
        return this.urlMode;
    }

    public static class Builder {
        private ImmutableMap.Builder<String, Object> dataBuilder;
        private Boolean hardwrap;
        private Boolean htmlEscaped;
        private UrlMode urlMode;

        public Builder() {
            this.urlMode = UrlMode.RELATIVE;
            this.dataBuilder = ImmutableMap.builder();
        }

        public Builder(RenderContext context) {
            this.hardwrap = context.hardwrap;
            this.htmlEscaped = context.htmlEscaped;
            this.urlMode = context.urlMode;
            this.dataBuilder = ImmutableMap.builder().putAll(context.data);
        }

        public RenderContext build() {
            return new RenderContext(this);
        }

        public Builder data(@Nonnull Map<String, Object> value) {
            this.dataBuilder.putAll((Map)Preconditions.checkNotNull(value, (Object)"data"));
            return this;
        }

        public Builder clearData() {
            this.dataBuilder = ImmutableMap.builder();
            return this;
        }

        public Builder hardwrap(boolean value) {
            this.hardwrap = value;
            return this;
        }

        public Builder htmlEscape(boolean value) {
            this.htmlEscaped = value;
            return this;
        }

        public Builder urlMode(@Nonnull UrlMode value) {
            this.urlMode = (UrlMode)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"urlMode"));
            return this;
        }
    }
}

