/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface Repository {
    public static final int MAX_NAME_LENGTH = 128;
    public static final int NAME_MAX_SIZE = 128;
    public static final String NAME_REGEXP = "[\\p{Alnum}][\\w\\-\\. ]*";
    public static final int SLUG_MAX_SIZE = 128;
    public static final String SLUG_REGEXP = "[\\p{Alnum}][\\w\\-\\.]*";

    @Nonnull
    public String getHierarchyId();

    public int getId();

    @Nonnull
    @RequiredString(size=128, regexp="[\\p{Alnum}][\\w\\-\\. ]*", message="{com.atlassian.bitbucket.validation.repository.name.pattern.message}")
    public String getName();

    @Nullable
    public Repository getOrigin();

    @Nonnull
    public Project getProject();

    @Nonnull
    @RequiredString
    public String getScmId();

    @Nonnull
    @RequiredString(size=128, regexp="[\\p{Alnum}][\\w\\-\\.]*")
    public String getSlug();

    @Nonnull
    public State getState();

    @Nonnull
    public String getStatusMessage();

    public boolean isFork();

    public boolean isForkable();

    public boolean isPublic();

    public static enum State {
        AVAILABLE(1, "Available"),
        INITIALISATION_FAILED(2, "Failed to initialise repository"),
        INITIALISING(0, "Initialising");

        private final int id;
        private final String statusMessage;

        private State(int id, String statusMessage) {
            this.id = id;
            this.statusMessage = (String)Preconditions.checkNotNull((Object)statusMessage, (Object)"statusMessage");
        }

        public int getId() {
            return this.id;
        }

        @Nonnull
        public String getStatusMessage() {
            return this.statusMessage;
        }

        public static State fromId(int id) {
            for (State value : State.values()) {
                if (value.getId() != id) continue;
                return value;
            }
            throw new IllegalArgumentException("No Repository.State is associated with ID [" + id + "]");
        }
    }
}

