/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mail;

import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.bitbucket.validation.annotation.OptionalString;
import com.atlassian.bitbucket.validation.annotation.RequiredString;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hibernate.validator.constraints.Range;

public class MailHostConfiguration {
    @RequiredString
    private final String hostname;
    @OptionalString
    private final String password;
    @Range(min=0L, max=65535L)
    private final Integer port;
    @Nonnull
    private final MailProtocol protocol;
    private final boolean requireStartTls;
    @OptionalString
    private final String username;
    private final boolean useStartTls;

    private MailHostConfiguration(Builder builder) {
        this.hostname = builder.hostname;
        this.password = builder.password;
        this.protocol = builder.protocol;
        this.port = builder.port;
        this.requireStartTls = builder.requireStartTls;
        this.username = builder.username;
        this.useStartTls = builder.useStartTls;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getPort() {
        return this.port;
    }

    @Nonnull
    public MailProtocol getProtocol() {
        return this.protocol;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isRequireStartTls() {
        return this.requireStartTls;
    }

    public boolean isUseStartTls() {
        return this.useStartTls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MailHostConfiguration that = (MailHostConfiguration)o;
        return Objects.equals(this.hostname, that.hostname) && Objects.equals(this.port, that.port) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals((Object)this.protocol, (Object)that.protocol) && this.useStartTls == that.useStartTls && this.requireStartTls == that.requireStartTls;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hostname, this.port, this.username, this.password, this.protocol, this.useStartTls, this.requireStartTls});
    }

    public static class Builder
    extends BuilderSupport {
        private String hostname;
        private String password;
        private Integer port;
        private MailProtocol protocol;
        private boolean requireStartTls;
        private String username;
        private boolean useStartTls;

        public Builder() {
            this.protocol = MailProtocol.SMTP;
        }

        public Builder(@Nonnull MailHostConfiguration other) {
            this.hostname(((MailHostConfiguration)Preconditions.checkNotNull((Object)other, (Object)"other")).hostname).port(other.port).username(other.username).protocol(other.protocol).useStartTls(other.useStartTls).requireStartTls(other.requireStartTls).password(other.password);
        }

        @Nonnull
        public MailHostConfiguration build() {
            return new MailHostConfiguration(this);
        }

        @Nonnull
        public Builder hostname(@Nonnull String value) {
            this.hostname = value;
            return this;
        }

        @Nonnull
        public Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        @Nonnull
        public Builder port(@Nullable Integer value) {
            this.port = value;
            return this;
        }

        @Nonnull
        public Builder protocol(@Nonnull MailProtocol value) {
            this.protocol = (MailProtocol)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"protocol"));
            return this;
        }

        @Nonnull
        public Builder requireStartTls(boolean value) {
            this.requireStartTls = value;
            if (value) {
                this.useStartTls = true;
            }
            return this;
        }

        @Nonnull
        public Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Nonnull
        public Builder useStartTls(boolean value) {
            this.useStartTls = value;
            if (!value) {
                this.requireStartTls = false;
            }
            return this;
        }
    }
}

