define('hipchat/page/repo-room-config', [
    'aui',
    'jquery',
    'lodash',
    'hipchat/feature/repo-room-table',
    'hipchat/feature/room-selector',
    'exports'
], function (
    AJS,
    $,
    _,
    RepoRoomTable,
    RoomSelector,
    exports
) {
    'use strict';


    /**
     * Inits the repo room table.
     *
     * @param {Repository} repository - The repository to be used when creating new mappings.
     * @param {Object} categories - Map containing category information split into different categories
     */
    function init (repository, categories) {
        if ($('.hipchat-needs-oauth').length === 0) {
            var repoRoomTable = new RepoRoomTable({
                categories: categories
            });
            repoRoomTable.init();

            var $addButton = $('#hipchat-repo-to-room-add');

            var roomSelector = RoomSelector.createRoomSelect($('#hipchat-repo-to-room-add-select'), checkRoomNotExist);
            roomSelector.select2.on('change', function () {
                $addButton.removeAttr('aria-disabled').removeAttr('disabled');
            });

            $addButton.on('click', function (e) {
                e.preventDefault();
                var room = roomSelector.getSelection();
                repoRoomTable.addRoomMapping(room, repository);
                // reset the select 2 there is no other nice way to do this.
                roomSelector.select2.auiSelect2('val', '')
            });
        }
    }

    /**
     * Checks if a mapping exists for the room already.
     *
     * Used to check if a room should show up in the selector.
     *
     * @param {Object} room
     * @returns {boolean}
     */
    function checkRoomNotExist (room) {
        return document.querySelector('tbody[data-room-id="' + room.id + '"]') == null;
    }

    exports.init = init;
});
