define('hipchat/page/global-config', [
    'jquery',
    'bitbucket/internal/feature/repository/global-repository-selector',
    'hipchat/feature/repo-room-table',
    'hipchat/feature/room-selector',
    'bitbucket/util/events',
    'bitbucket/util/navbuilder',
    'exports'
], function (
    $,
    GlobalRepositorySelector,
    RepoRoomTable,
    RoomSelector,
    events,
    navbuilder,
    exports
) {

    'use strict';

    /**
     * Inits the repo room table.
     *
     * @param {Object} categories - Map containing category information split into different categories
     */
    function init (categories) {
        var repoRoomTable = new RepoRoomTable({
            categories: categories,
            baseUrlBuilder: navbuilder.rest('hipchat-integrations').addPathComponents('global-notifications'),
            showProject: true
        });
        repoRoomTable.init();

        var repoSelected = false;
        var roomSelected = false;

        var repositorySelector = new GlobalRepositorySelector($('#repository-selector'), {
            id: 'repository-selector-dialog',
            permission: 'REPO_ADMIN'
        });

        var $addButton = $('#hipchat-repo-to-room-add');

        // no room filter because there are too many combinations and hiding rooms might just cause more confusion,
        // we have an error for when duplicate rooms are added.
        var roomSelector = RoomSelector.createRoomSelect($('#hipchat-repo-to-room-add-select'), function () { return true; });

        // once both the room and repo are selected active the add button
        roomSelector.select2.on('change', function () {
            roomSelected = true;
            toggleDisabled($addButton, roomSelected && repoSelected);
        });
        events.once('bitbucket.internal.feature.repository.repositorySelector.repositoryChanged', function () {
            repoSelected = true;
            toggleDisabled($addButton, roomSelected && repoSelected);
        });

        $addButton.on('click', function (e) {
            e.preventDefault();
            var room = roomSelector.getSelection();
            var repository = repositorySelector.getSelectedItem();
            repoRoomTable.addRoomMapping(room, repository.toJSON());
            // reset the select 2 there is no other nice way to do this.
            $(roomSelector.select2[0]).select2('val', '');
            roomSelected = false;
            toggleDisabled($addButton, roomSelected && repoSelected);
            // advance the progress indicator for the initial install screen
            $('.hipchat-integration-steps').addClass("complete");
        });
    }

    function toggleDisabled ($addButton, state) {
        if (state) {
            $addButton.removeAttr('aria-disabled').removeAttr('disabled');
        } else {
            $addButton.attr('aria-disabled', '').attr('disabled', '');
        }
    }

    exports.init = init;
});