/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest;

import com.atlassian.bitbucket.hipchat.notification.configuration.RoomConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest.RestNotificationConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest.RestRoomDetails;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=RoomConfiguration.class)
public class RestRoomConfiguration {
    private final RestRoomDetails roomDetails;
    private final Iterable<RestNotificationConfiguration> notificationConfigs;

    public RestRoomConfiguration(RoomConfiguration roomConfiguration) {
        this.notificationConfigs = Iterables.transform(roomConfiguration.getNotificationConfigurations(), RestNotificationConfiguration::new);
        this.roomDetails = new RestRoomDetails(roomConfiguration.getRoomDetails());
    }

    @JsonProperty
    @Nonnull
    public Iterable<RestNotificationConfiguration> getNotificationConfigs() {
        return this.notificationConfigs;
    }

    @JsonProperty
    @Nonnull
    public RestRoomDetails getRoomDetails() {
        return this.roomDetails;
    }
}

