/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest;

import com.atlassian.bitbucket.hipchat.notification.NotificationTypeService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfigurationService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationDisableRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationEnableRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationSearchRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.rest.RestRepositoryConfiguration;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.RestResource;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.fugue.Option;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class NotificationConfigurationResource
extends RestResource {
    private final NotificationConfigurationService notificationConfigService;
    private final NotificationTypeService notificationTypeService;

    public NotificationConfigurationResource(I18nService i18nService, NotificationConfigurationService notificationConfigService, NotificationTypeService notificationTypeService) {
        super(i18nService);
        this.notificationConfigService = notificationConfigService;
        this.notificationTypeService = notificationTypeService;
    }

    @DELETE
    @Path(value="/rooms/{roomId}")
    public Response disableAllNotifications(@Context Repository repository, @PathParam(value="roomId") String roomId) {
        NotificationDisableRequest request = ((NotificationDisableRequest.Builder)((Object)((NotificationDisableRequest.Builder)((Object)new NotificationDisableRequest.Builder().roomId(roomId))).repository(repository))).build();
        this.notificationConfigService.disable(request);
        return ResponseFactory.ok().build();
    }

    @DELETE
    @Path(value="/rooms/{roomId}/notifications/{notificationKey}")
    public Response disableNotification(@Context Repository repository, @PathParam(value="roomId") String roomId, @PathParam(value="notificationKey") String notificationKey) {
        Option<NotificationType> notificationType = this.notificationTypeService.getByKey(notificationKey);
        if (notificationType.isEmpty()) {
            return ResponseFactory.notFound().entity((Object)new RestErrors(this.i18nService.getMessage("bitbucket.hipchat.nosuchnotificationtype", new Object[]{notificationKey}))).build();
        }
        NotificationDisableRequest request = ((NotificationDisableRequest.Builder)((Object)((NotificationDisableRequest.Builder)((Object)((NotificationDisableRequest.Builder)((Object)new NotificationDisableRequest.Builder().roomId(roomId))).repository(repository))).notificationType((NotificationType)notificationType.get()))).build();
        this.notificationConfigService.disable(request);
        return ResponseFactory.ok().build();
    }

    @PUT
    @Path(value="/rooms/{roomId}")
    public Response enableAllNotifications(@Context Repository repository, @PathParam(value="roomId") String roomId) {
        Iterable<NotificationType> notificationTypes = this.notificationTypeService.getAll();
        NotificationEnableRequest request = ((NotificationEnableRequest.Builder)((Object)((NotificationEnableRequest.Builder)((Object)((NotificationEnableRequest.Builder)((Object)new NotificationEnableRequest.Builder().roomId(roomId))).repository(repository))).notificationTypes(notificationTypes))).build();
        this.notificationConfigService.enable(request);
        return ResponseFactory.ok().build();
    }

    @PUT
    @Path(value="/rooms/{roomId}/notifications/{notificationKey}")
    public Response enableNotification(@Context Repository repository, @PathParam(value="roomId") String roomId, @PathParam(value="notificationKey") String notificationKey) {
        Option<NotificationType> notificationType = this.notificationTypeService.getByKey(notificationKey);
        if (notificationType.isEmpty()) {
            return ResponseFactory.notFound().entity((Object)new RestErrors(this.i18nService.getMessage("bitbucket.hipchat.nosuchnotificationtype", new Object[]{notificationKey}))).build();
        }
        NotificationEnableRequest request = ((NotificationEnableRequest.Builder)((Object)((NotificationEnableRequest.Builder)((Object)((NotificationEnableRequest.Builder)((Object)new NotificationEnableRequest.Builder().roomId(roomId))).repository(repository))).notificationType((NotificationType)notificationType.get()))).build();
        this.notificationConfigService.enable(request);
        return ResponseFactory.ok().build();
    }

    @GET
    public Response notifications(@Context Repository repository, @Context PageRequest pageRequest) {
        NotificationSearchRequest request = ((NotificationSearchRequest.Builder)((Object)new NotificationSearchRequest.Builder().repository(repository))).build();
        Page<RepositoryConfiguration> repoConfigPage = this.notificationConfigService.search(request, pageRequest);
        return ResponseFactory.ok().entity((Object)new RestPage(repoConfigPage, RestRepositoryConfiguration::new)).build();
    }
}

