/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.hipchat.notification.NotificationTypeService;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationDisableRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationEnableRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationSearchRequest;
import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.RoomDetails;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.DefaultNotificationConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.DefaultRepositoryConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.DefaultRoomDetails;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.dao.AoNotificationConfiguration;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.dao.NotificationConfigurationDao;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.ResourceError;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.plugins.hipchat.api.HipChatApiService;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.util.concurrent.Promise;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;
import net.java.ao.Query;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoNotificationConfigurationDao
extends AbstractAoDao
implements NotificationConfigurationDao {
    private static final String AND_QUERY = " = ? AND ";
    private static final Logger logger = LoggerFactory.getLogger(AoNotificationConfigurationDao.class);
    private static final String PLUGIN_PREFIX = "plugin.bitbucket-hipchat-integration.";
    private static final String PROPERTY_HC_TIMEOUT = "plugin.bitbucket-hipchat-integration.hipchat.timeout";
    private final int hipChatTimeout;
    private final HipChatApiService hipChatApiService;
    private final NotificationTypeService notificationTypeService;
    private final RepositoryService repositoryService;
    private final TransactionTemplate transactionTemplate;

    public AoNotificationConfigurationDao(ActiveObjects ao, HipChatApiService hipChatApiService, NotificationTypeService notificationTypeService, ApplicationPropertiesService propertiesService, RepositoryService repositoryService, TransactionTemplate transactionTemplate) {
        super(ao);
        this.hipChatApiService = hipChatApiService;
        this.notificationTypeService = notificationTypeService;
        this.repositoryService = repositoryService;
        this.transactionTemplate = transactionTemplate;
        this.hipChatTimeout = propertiesService.getPluginProperty(PROPERTY_HC_TIMEOUT, 30);
    }

    @Override
    public void create(@Nonnull NotificationEnableRequest request) {
        this.transactionTemplate.execute(() -> {
            Iterable<NotificationType> notificationTypes = request.getNotificationTypes();
            for (NotificationType notificationType : notificationTypes) {
                Option<Repository> repository = request.getRepository();
                Option<String> roomId = request.getRoomId();
                if (this.notificationExists((Option<NotificationType>)Option.some((Object)notificationType), repository, roomId)) continue;
                this.ao.create(AoNotificationConfiguration.class, (Map)ImmutableMap.of((Object)"NOTIFICATION_TYPE", (Object)notificationType.getKey(), (Object)"REPO_ID", (Object)((Repository)repository.get()).getId(), (Object)"ROOM_ID", (Object)roomId.get()));
            }
            return null;
        });
    }

    @Override
    public void delete(@Nonnull NotificationDisableRequest request) {
        StringBuilder query = new StringBuilder();
        ImmutableList.Builder parameters = ImmutableList.builder();
        Iterable<NotificationType> notificationTypes = request.getNotificationTypes();
        if (!Iterables.isEmpty(notificationTypes)) {
            List<Character> inputs = Collections.nCopies(Iterables.size(notificationTypes), Character.valueOf('?'));
            parameters.addAll((Iterable)MoreStreams.streamIterable(notificationTypes).map(NotificationType::getKey).collect(Collectors.toList()));
            query.append("NOTIFICATION_TYPE IN (" + StringUtils.join(inputs, (char)',') + ")  AND ");
        }
        this.where("REPO_ID", request.getRepository(), (ImmutableList.Builder<Object>)parameters, query, Repository::getId);
        this.where("ROOM_ID", request.getRoomId(), (ImmutableList.Builder<Object>)parameters, query, value -> value);
        this.ao.deleteWithSQL(AoNotificationConfiguration.class, this.removeTrailingAND(query), parameters.build().toArray());
    }

    @Override
    public Set<String> getRoomIds(NotificationSearchRequest request) {
        Query query = this.createQuery((Option<String>)Option.some((Object)"ROOM_ID"), request.getNotificationType(), request.getRepository());
        AoNotificationConfiguration[] configurations = (AoNotificationConfiguration[])this.ao.find(AoNotificationConfiguration.class, query);
        return Arrays.stream(configurations).map(AoNotificationConfiguration::getRoomId).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public Page<RepositoryConfiguration> search(@Nonnull NotificationSearchRequest request, @Nonnull PageRequest pageRequest) {
        Option<NotificationType> notificationType = request.getNotificationType();
        Option<Repository> repository = request.getRepository();
        Page<AoNotificationConfiguration> pageRepoId = this.queryRepoIds(pageRequest, notificationType, repository);
        ImmutableList<AoNotificationConfiguration> notificationConfigs = this.queryNotificationConfigs(notificationType, pageRepoId);
        return this.convert(pageRequest, (Page)pageRepoId, (Iterable<AoNotificationConfiguration>)notificationConfigs);
    }

    private Page<RepositoryConfiguration> convert(PageRequest pageRequest, Page page, Iterable<AoNotificationConfiguration> aoNotificationConfigs) {
        Iterable<RepositoryConfiguration> repoConfigs = this.convert(aoNotificationConfigs);
        return PageUtils.createPage(repoConfigs, (boolean)page.getIsLastPage(), (PageRequest)pageRequest);
    }

    private Iterable<RepositoryConfiguration> convert(Iterable<AoNotificationConfiguration> aoNotificationConfigs) {
        ImmutableSet.Builder roomIdBuilder = ImmutableSet.builder();
        for (AoNotificationConfiguration aoNotificationConfig : aoNotificationConfigs) {
            roomIdBuilder.add((Object)aoNotificationConfig.getRoomId());
        }
        ImmutableSet roomIds = roomIdBuilder.build();
        Map<String, RoomDetails> roomDetails = this.hipChatRooms((Set<String>)roomIds);
        return this.convert(aoNotificationConfigs, roomDetails);
    }

    private Iterable<RepositoryConfiguration> convert(Iterable<AoNotificationConfiguration> aoNotificationConfigs, Map<String, RoomDetails> roomDetails) {
        return MoreStreams.streamIterable(aoNotificationConfigs).collect(Collectors.groupingBy(AoNotificationConfiguration::getRepoId)).entrySet().stream().flatMap(entry -> {
            Integer repoId = (Integer)entry.getKey();
            Repository repository = this.repositoryService.getById(repoId.intValue());
            if (repository == null) {
                logger.error("Repository with ID " + repoId + " does not exist!");
                this.deleteRepositoryNotifications(repoId);
                return Stream.empty();
            }
            DefaultRepositoryConfiguration.Builder builder = new DefaultRepositoryConfiguration.Builder(repository);
            ((List)entry.getValue()).forEach(aoConfig -> {
                NotificationConfiguration config = this.notificationConfig((AoNotificationConfiguration)aoConfig);
                builder.roomConfiguration(config, (RoomDetails)roomDetails.get(aoConfig.getRoomId()));
            });
            return Stream.of(builder.build());
        }).collect(Collectors.toList());
    }

    private Query createQuery(Option<NotificationType> notificationType, Option<Repository> repository) {
        return this.createQuery((Option<String>)Option.none(), notificationType, repository);
    }

    private Query createQuery(Option<String> column, Option<NotificationType> notificationType, Option<Repository> repository) {
        Query query = (Query)column.fold(() -> Query.select((String)"ID,NOTIFICATION_TYPE,REPO_ID,ROOM_ID"), Query::select);
        this.where("NOTIFICATION_TYPE", notificationType, query, NotificationType::getKey);
        this.where("REPO_ID", repository, query, Repository::getId);
        query.distinct();
        query.order("REPO_ID ASC");
        return query;
    }

    private void deleteRepositoryNotifications(Integer repoId) {
        StringBuilder query = new StringBuilder();
        ImmutableList.Builder parameters = ImmutableList.builder();
        this.where("REPO_ID", Option.some((Object)repoId), (ImmutableList.Builder<Object>)parameters, query, value -> value);
        logger.warn("Deleting all hipchat notification settings for repository with ID " + repoId);
        this.ao.deleteWithSQL(AoNotificationConfiguration.class, this.removeTrailingAND(query), parameters.build().toArray());
    }

    private Map<String, RoomDetails> errorRooms(Iterable<String> roomIds) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String roomId : roomIds) {
            builder.put((Object)roomId, (Object)new DefaultRoomDetails.Builder().roomId(roomId).state(RoomDetails.State.UNKNOWN_ERROR).build());
        }
        return builder.build();
    }

    private Map<String, RoomDetails> hipChatRooms(Set<String> roomIds) {
        Promise expandRoomsPromise = this.hipChatApiService.expandRoomsForIds(roomIds);
        try {
            return this.roomDetails((Map)expandRoomsPromise.get((long)this.hipChatTimeout, TimeUnit.SECONDS));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            logger.error("Failed to retrieve room details from hipchat.", (Throwable)e);
            return this.errorRooms(roomIds);
        }
    }

    private NotificationConfiguration notificationConfig(AoNotificationConfiguration aoNotificationConfig) {
        Option<NotificationType> notificationType = this.notificationTypeService.getByKey(aoNotificationConfig.getNotificationType());
        return new DefaultNotificationConfiguration.Builder((NotificationType)notificationType.get()).build();
    }

    private boolean notificationExists(Option<NotificationType> notificationType, Option<Repository> repository, Option<String> roomId) {
        Query query = this.createQuery(notificationType, repository);
        this.where("ROOM_ID", roomId, query, value -> value);
        return ((AoNotificationConfiguration[])this.ao.find(AoNotificationConfiguration.class, query)).length > 0;
    }

    private ImmutableList<AoNotificationConfiguration> queryNotificationConfigs(Option<NotificationType> notificationType, Page<AoNotificationConfiguration> pageRepoId) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Set repoIds = MoreStreams.streamIterable((Iterable)pageRepoId.getValues()).map(AoNotificationConfiguration::getRepoId).collect(Collectors.toSet());
        for (List ids : Iterables.partition(repoIds, (int)100)) {
            Query query = Query.select((String)"ID,NOTIFICATION_TYPE,REPO_ID,ROOM_ID");
            query.where("REPO_ID IN (" + StringUtils.join((Collection)ids, (char)',') + ") ", new Object[0]);
            this.where("NOTIFICATION_TYPE", notificationType, query, NotificationType::getKey);
            builder.add((Object[])this.ao.find(AoNotificationConfiguration.class, query));
        }
        return builder.build();
    }

    private Page<AoNotificationConfiguration> queryRepoIds(PageRequest pageRequest, Option<NotificationType> notificationType, Option<Repository> repository) {
        Query repoIdQuery = this.createQuery((Option<String>)Option.some((Object)"REPO_ID"), notificationType, repository);
        return this.pageQuery(AoNotificationConfiguration.class, repoIdQuery, pageRequest);
    }

    private String removeTrailingAND(StringBuilder query) {
        int length = query.length();
        if (length > 0) {
            return query.substring(0, length - 5);
        }
        return query.toString();
    }

    private Map<String, RoomDetails> roomDetails(Map<String, Result<ExpandedRoom>> resultMap) {
        return resultMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> this.roomDetails((String)entry.getKey(), (Result<ExpandedRoom>)((Result)entry.getValue()))));
    }

    private DefaultRoomDetails roomDetails(String roomId, Result<ExpandedRoom> roomResult) {
        if (roomResult.isSuccess()) {
            ExpandedRoom expandedRoom = (ExpandedRoom)roomResult.success();
            return new DefaultRoomDetails.Builder().roomId(roomId).roomName(expandedRoom.getName()).state(expandedRoom.getIsArchived() ? RoomDetails.State.ARCHIVED : RoomDetails.State.AVAILABLE).build();
        }
        ResourceError error = roomResult.error();
        Response.Status status = Response.Status.fromStatusCode((int)error.getStatusCode());
        return new DefaultRoomDetails.Builder().roomId(roomId).state(status).build();
    }

    private <A> void where(String column, Option<A> option, Query query, Function<A, Object> function) {
        option.foreach(value -> {
            String whereClause = query.getWhereClause();
            Object[] whereParams = query.getWhereParams();
            if (StringUtils.isEmpty((String)whereClause)) {
                query.where(column + " = ? ", new Object[]{function.apply(value)});
            } else {
                StringBuilder whereBuilder = new StringBuilder(whereClause);
                query.where(whereBuilder.append(" AND ").append(column + " = ? ").toString(), ImmutableList.builder().add(whereParams).add(function.apply(value)).build().toArray());
            }
        });
    }

    private <A> void where(String column, Option<A> option, ImmutableList.Builder<Object> parameters, StringBuilder query, Function<A, Object> function) {
        option.foreach(value -> {
            query.append(column);
            query.append(AND_QUERY);
            parameters.add(function.apply(value));
        });
    }
}

