/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.hipchat.notification.configuration.RoomDetails;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.ws.rs.core.Response;

public class DefaultRoomDetails
implements RoomDetails {
    private final String roomId;
    private final String roomName;
    private final RoomDetails.State state;

    private DefaultRoomDetails(Builder builder) {
        this.roomId = builder.roomId;
        this.roomName = builder.roomName;
        this.state = builder.state;
    }

    @Override
    @Nonnull
    public String getRoomId() {
        return this.roomId;
    }

    @Override
    @Nonnull
    public String getRoomName() {
        return this.roomName;
    }

    @Override
    @Nonnull
    public RoomDetails.State getState() {
        return this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRoomDetails that = (DefaultRoomDetails)o;
        return this.roomId.equals(that.roomId);
    }

    public int hashCode() {
        return this.roomId.hashCode();
    }

    public static class Builder {
        private String roomId;
        private String roomName;
        private RoomDetails.State state;

        public DefaultRoomDetails build() {
            return new DefaultRoomDetails(this);
        }

        public Builder roomId(@Nonnull String value) {
            this.roomId = (String)Preconditions.checkNotNull((Object)value, (Object)"roomId");
            return this;
        }

        public Builder roomName(@Nonnull String value) {
            this.roomName = (String)Preconditions.checkNotNull((Object)value, (Object)"roomName");
            return this;
        }

        public Builder state(@Nonnull RoomDetails.State value) {
            this.state = (RoomDetails.State)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"state"));
            return this;
        }

        public Builder state(Response.Status value) {
            return this.state(Builder.fromStatus((Response.Status)Preconditions.checkNotNull((Object)value, (Object)"status")));
        }

        private static RoomDetails.State fromStatus(@Nonnull Response.Status status) {
            switch (status) {
                case OK: {
                    return RoomDetails.State.AVAILABLE;
                }
                case FORBIDDEN: {
                    return RoomDetails.State.FORBIDDEN;
                }
                case NOT_FOUND: {
                    return RoomDetails.State.NOT_FOUND;
                }
            }
            return RoomDetails.State.UNKNOWN_ERROR;
        }
    }
}

