/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.RoomConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.RoomDetails;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.DefaultNotificationConfiguration;
import com.atlassian.plugins.hipchat.api.notification.NotificationType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DefaultRoomConfiguration
implements RoomConfiguration {
    private final Set<NotificationConfiguration> notificationConfigs;
    private final RoomDetails roomDetails;

    private DefaultRoomConfiguration(Builder builder) {
        this.roomDetails = builder.roomDetails;
        this.notificationConfigs = builder.notificationConfigs.build();
    }

    @Override
    @Nonnull
    public Set<NotificationConfiguration> getNotificationConfigurations() {
        return this.notificationConfigs;
    }

    @Override
    @Nonnull
    public RoomDetails getRoomDetails() {
        return this.roomDetails;
    }

    @Override
    public boolean isEnabled(NotificationType notificationType) {
        return this.notificationConfigs.contains(new DefaultNotificationConfiguration.Builder(notificationType).build());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRoomConfiguration that = (DefaultRoomConfiguration)o;
        return this.roomDetails.equals(that.roomDetails);
    }

    public int hashCode() {
        return this.roomDetails.hashCode();
    }

    public static class Builder {
        private ImmutableSet.Builder<NotificationConfiguration> notificationConfigs = ImmutableSet.builder();
        private RoomDetails roomDetails;

        public Builder(@Nonnull RoomDetails roomDetails) {
            this.roomDetails = (RoomDetails)Preconditions.checkNotNull((Object)roomDetails, (Object)"roomDetails");
        }

        @Nonnull
        public DefaultRoomConfiguration build() {
            return new DefaultRoomConfiguration(this);
        }

        @Nonnull
        public Builder notificationConfiguration(@Nonnull NotificationConfiguration value) {
            this.notificationConfigs.add(Preconditions.checkNotNull((Object)value, (Object)"notificationConfig"));
            return this;
        }
    }
}

