/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification.configuration;

import com.atlassian.bitbucket.hipchat.notification.configuration.NotificationConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.RepositoryConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.RoomConfiguration;
import com.atlassian.bitbucket.hipchat.notification.configuration.RoomDetails;
import com.atlassian.bitbucket.internal.hipchat.notification.configuration.DefaultRoomConfiguration;
import com.atlassian.bitbucket.repository.Repository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class DefaultRepositoryConfiguration
implements RepositoryConfiguration {
    private final Repository repository;
    private final Set<RoomConfiguration> roomConfigs;

    private DefaultRepositoryConfiguration(Builder builder) {
        this.repository = builder.repository;
        this.roomConfigs = builder.roomConfigs;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    @Nonnull
    public Set<RoomConfiguration> getRoomConfigurations() {
        return this.roomConfigs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRepositoryConfiguration that = (DefaultRepositoryConfiguration)o;
        return this.repository.equals(that.repository);
    }

    public int hashCode() {
        return this.repository.hashCode();
    }

    public static class Builder {
        private Repository repository;
        private Map<String, DefaultRoomConfiguration.Builder> roomConfigBuilders = Maps.newHashMap();
        private Set<RoomConfiguration> roomConfigs;

        public Builder(@Nonnull Repository repository) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository");
        }

        @Nonnull
        public DefaultRepositoryConfiguration build() {
            this.roomConfigs = this.roomConfigBuilders.values().stream().map(DefaultRoomConfiguration.Builder::build).collect(Collectors.toSet());
            return new DefaultRepositoryConfiguration(this);
        }

        @Nonnull
        public Builder roomConfiguration(@Nonnull NotificationConfiguration config, @Nonnull RoomDetails roomDetails) {
            DefaultRoomConfiguration.Builder builder = this.roomConfigurationBuilder(roomDetails);
            builder.notificationConfiguration(config);
            return this;
        }

        private DefaultRoomConfiguration.Builder roomConfigurationBuilder(@Nonnull RoomDetails roomDetails) {
            String roomId = roomDetails.getRoomId();
            DefaultRoomConfiguration.Builder builder = this.roomConfigBuilders.get(roomId);
            if (builder == null) {
                builder = new DefaultRoomConfiguration.Builder(roomDetails);
                this.roomConfigBuilders.put(roomId, builder);
            }
            return builder;
        }
    }
}

