/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification;

import com.atlassian.bitbucket.event.repository.RepositoryPushEvent;
import com.atlassian.bitbucket.internal.hipchat.notification.BitbucketHipChatNotification;
import com.atlassian.bitbucket.internal.hipchat.notification.HipChatNotificationRenderer;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class RepositoryPushNotification
implements BitbucketHipChatNotification<RepositoryPushEvent> {
    private static final Predicate<RefChange> IS_BRANCH = input -> input.getRef().getType() == StandardRefType.BRANCH;
    private final HipChatNotificationRenderer renderer;

    public RepositoryPushNotification(HipChatNotificationRenderer renderer) {
        this.renderer = renderer;
    }

    public Class<RepositoryPushEvent> getEventClass() {
        return RepositoryPushEvent.class;
    }

    public boolean shouldSend(RepositoryPushEvent event) {
        Collection refChanges = Collections2.filter((Collection)event.getRefChanges(), IS_BRANCH);
        return !refChanges.isEmpty();
    }

    public String getMessage(RepositoryPushEvent event) {
        Collection refChanges = event.getRefChanges();
        return this.renderer.getCommitPushMessage(event.getUser(), event.getRepository(), Iterables.filter((Iterable)refChanges, IS_BRANCH));
    }

    @Override
    public HipChatNotificationOptions getNotificationOptions(RepositoryPushEvent event) {
        return HipChatNotificationOptions.GRAY;
    }
}

