/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification;

import com.atlassian.bitbucket.hipchat.notification.RepositoryLinkedEvent;
import com.atlassian.bitbucket.internal.hipchat.notification.HipChatNotificationRenderer;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.rooms.MessageBgColor;
import com.atlassian.plugins.hipchat.api.HipChatApiService;
import com.atlassian.sal.api.net.ResponseException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryLinkedEventListener {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryLinkedEventListener.class);
    private final HipChatApiService hipChatApiService;
    private final HipChatNotificationRenderer renderer;

    public RepositoryLinkedEventListener(HipChatApiService hipChatApiService, HipChatNotificationRenderer renderer) {
        this.hipChatApiService = hipChatApiService;
        this.renderer = renderer;
    }

    @EventListener
    public void onRepositoryLinked(RepositoryLinkedEvent event) {
        String message = this.renderer.getRepositoryLinkedMessage(event);
        if (StringUtils.isNotEmpty((String)message)) {
            try {
                this.hipChatApiService.notifyRoom(event.getRoomId(), message, Option.some((Object)MessageBgColor.GREEN));
            }
            catch (ResponseException e) {
                logger.warn("Unable to send HipChat Notification.", (Throwable)e);
            }
        }
    }
}

