/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.hipchat.notification.NotificationTypeService;
import com.atlassian.bitbucket.internal.hipchat.notification.BitbucketHipChatNotification;
import com.atlassian.bitbucket.internal.hipchat.notification.RoomNotification;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.event.api.EventListener;
import com.atlassian.fugue.Suppliers;
import com.atlassian.plugins.hipchat.api.HipChatApiService;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotification;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationContext;
import com.atlassian.plugins.hipchat.api.notification.HipChatNotificationOptions;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationEventListener {
    private static final Logger logger = LoggerFactory.getLogger(NotificationEventListener.class);
    private final HipChatApiService hipChatApiService;
    private final NotificationTypeService notificationTypeService;

    public NotificationEventListener(HipChatApiService hipChatApiService, NotificationTypeService notificationTypeService) {
        this.hipChatApiService = hipChatApiService;
        this.notificationTypeService = notificationTypeService;
    }

    @EventListener
    public void onEvent(ApplicationEvent event) {
        Map<String, HipChatNotificationContext> contexts = this.notificationTypeService.getAllContexts();
        MoreStreams.streamIterable(this.notificationTypeService.getAll()).filter(notificationType -> (Boolean)notificationType.getNotification().fold(Suppliers.alwaysFalse(), notification -> notification.getEventClass().isAssignableFrom(event.getClass()) && notification.shouldSend((Object)event))).flatMap(notificationType -> {
            HipChatNotificationContext notificationContext = (HipChatNotificationContext)contexts.get(notificationType.getContext());
            Iterable roomIds = notificationContext.getRoomIds((Object)event, notificationType);
            if (!Iterables.isEmpty((Iterable)roomIds)) {
                HipChatNotification hipChatNotification = (HipChatNotification)notificationType.getNotification().get();
                String message = hipChatNotification.getMessage((Object)event);
                HipChatNotificationOptions options = this.getNotificationOptions(hipChatNotification, event);
                if (StringUtils.isNotEmpty((String)message)) {
                    return MoreStreams.streamIterable((Iterable)roomIds).map(roomId -> new RoomNotification.Builder().message(message).options(options).roomId((String)roomId).build());
                }
            }
            return Stream.empty();
        }).forEach(roomNotification -> {
            try {
                this.hipChatApiService.notifyRoom(roomNotification.getRoomId(), roomNotification.getMessage(), roomNotification.getOptions());
            }
            catch (ResponseException e) {
                logger.warn("Unable to send HipChat Notification.", (Throwable)e);
            }
        });
    }

    private HipChatNotificationOptions getNotificationOptions(HipChatNotification hipChatNotification, Object event) {
        if (hipChatNotification instanceof BitbucketHipChatNotification) {
            return ((BitbucketHipChatNotification)hipChatNotification).getNotificationOptions(event);
        }
        return HipChatNotificationOptions.GRAY;
    }
}

