/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.hipchat.notification;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.event.commit.CommitDiscussionCommentEvent;
import com.atlassian.bitbucket.event.pull.PullRequestCommentEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantApprovedEvent;
import com.atlassian.bitbucket.hipchat.notification.RepositoryLinkedEvent;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Operation;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HipChatNotificationRenderer {
    private static final String COMMIT_TEMPLATE = "bitbucket.internal.hipchat.messages.commits.";
    protected static final String COMMIT_DISCUSSION_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.commits.commented";
    protected static final String COMMIT_PUSHED_TEMPLATE = "bitbucket.internal.hipchat.messages.commits.pushed";
    private static final int MAX_COMMITS_TO_SHOW = 5;
    private static final int MAX_COMMITS = 7;
    private static final int MAX_REF_CHANGES_TO_SHOW = 5;
    protected static final String MODULE_KEY = "com.atlassian.stash.plugins.stash-hipchat-integration-plugin:message-templates";
    private static final String PULL_REQUEST_TEMPLATE = "bitbucket.internal.hipchat.messages.pullRequest.";
    protected static final String PULL_APPROVED_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.pullRequest.approved";
    protected static final String PULL_COMMENTED_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.pullRequest.commented";
    protected static final String PULL_DECLINED_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.pullRequest.declined";
    protected static final String PULL_MERGED_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.pullRequest.merged";
    protected static final String PULL_OPENED_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.pullRequest.opened";
    protected static final String REPO_LINKED_TEMPLATE_NAME = "bitbucket.internal.hipchat.messages.repository.linked";
    private static final Logger logger = LoggerFactory.getLogger(HipChatNotificationRenderer.class);
    private final CommitService commitService;
    private final NavBuilder navBuilder;
    private final SecurityService securityService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public HipChatNotificationRenderer(CommitService commitService, NavBuilder navBuilder, SecurityService securityService, SoyTemplateRenderer soyTemplateRenderer) {
        this.commitService = commitService;
        this.navBuilder = navBuilder;
        this.securityService = securityService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    public String getCommitDiscussionMessage(CommitDiscussionCommentEvent event) {
        Repository repository = event.getRepository();
        String commitId = event.getDiscussion().getCommitId();
        ImmutableMap soyData = ImmutableMap.of((Object)"comment", (Object)event.getComment(), (Object)"commit", this.commitModel(this.getCommit(repository, commitId)), (Object)"repository", (Object)repository, (Object)"user", (Object)event.getUser());
        return this.render((Map<String, Object>)soyData, COMMIT_DISCUSSION_TEMPLATE_NAME);
    }

    public String getCommitPushMessage(ApplicationUser user, Repository repository, Iterable<RefChange> refChanges) {
        ImmutableMap soyData = ImmutableMap.of((Object)"totalRefCount", (Object)Iterables.size(refChanges), (Object)"refs", this.formatRefChanges(refChanges, repository), (Object)"repository", (Object)repository, (Object)"user", (Object)user);
        return this.render((Map<String, Object>)soyData, COMMIT_PUSHED_TEMPLATE);
    }

    public String getPullRequestApprovedMessage(PullRequestParticipantApprovedEvent event) {
        ImmutableMap soyData = ImmutableMap.of((Object)"pullRequest", (Object)event.getPullRequest(), (Object)"repository", (Object)event.getPullRequest().getToRef().getRepository(), (Object)"user", (Object)event.getParticipant().getUser());
        return this.render((Map<String, Object>)soyData, PULL_APPROVED_TEMPLATE_NAME);
    }

    public String getPullRequestCommentMessage(PullRequestCommentEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        ImmutableMap soyData = ImmutableMap.of((Object)"comment", (Object)event.getComment(), (Object)"pullRequest", (Object)pullRequest, (Object)"repository", (Object)pullRequest.getToRef().getRepository(), (Object)"user", (Object)event.getUser());
        return this.render((Map<String, Object>)soyData, PULL_COMMENTED_TEMPLATE_NAME);
    }

    public String getPullRequestDeclinedMessage(PullRequestDeclinedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        ImmutableMap soyData = ImmutableMap.of((Object)"pullRequest", (Object)pullRequest, (Object)"repository", (Object)pullRequest.getToRef().getRepository(), (Object)"user", (Object)event.getUser());
        return this.render((Map<String, Object>)soyData, PULL_DECLINED_TEMPLATE_NAME);
    }

    public String getPullRequestMergedMessage(PullRequestMergedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        ImmutableMap soyData = ImmutableMap.of((Object)"pullRequest", (Object)pullRequest, (Object)"repository", (Object)pullRequest.getToRef().getRepository(), (Object)"user", (Object)event.getUser());
        return this.render((Map<String, Object>)soyData, PULL_MERGED_TEMPLATE_NAME);
    }

    public String getPullRequestOpenedMessage(PullRequestOpenedEvent event) {
        PullRequest pullRequest = event.getPullRequest();
        ImmutableMap soyData = ImmutableMap.of((Object)"pullRequest", (Object)pullRequest, (Object)"repository", (Object)pullRequest.getToRef().getRepository(), (Object)"user", (Object)event.getUser());
        return this.render((Map<String, Object>)soyData, PULL_OPENED_TEMPLATE_NAME);
    }

    public String getRepositoryLinkedMessage(RepositoryLinkedEvent event) {
        ImmutableMap soyData = ImmutableMap.of((Object)"repository", (Object)event.getRepository());
        return this.render((Map<String, Object>)soyData, REPO_LINKED_TEMPLATE_NAME);
    }

    private Map<String, String> commitModel(Commit commit) {
        return ImmutableMap.of((Object)"message", (Object)commit.getMessage(), (Object)"hash", (Object)commit.getDisplayId(), (Object)"url", (Object)this.navBuilder.repo(commit.getRepository()).commit(commit.getId()).buildConfigured());
    }

    private Collection<Map<String, Object>> formatRefChanges(Iterable<RefChange> refChanges, Repository repository) {
        return Chainable.chain(refChanges).transform(refChange -> {
            Iterable<Map<String, String>> commits = this.getCommits((RefChange)refChange, repository);
            return ImmutableMap.of((Object)"branch", (Object)ImmutableMap.of((Object)"id", (Object)refChange.getRefId(), (Object)"displayId", (Object)GitRefPattern.HEADS.unqualify(refChange.getRefId())), (Object)"commits", commits, (Object)"type", (Object)refChange.getType().toString());
        }).limit(5).toList();
    }

    private Commit getCommit(Repository repository, String commitId) {
        return this.commitService.getCommit(new CommitRequest.Builder(repository, commitId).build());
    }

    private Iterable<Map<String, String>> getCommits(RefChange refChange, Repository repository) {
        Iterable commits = this.commitService.getCommitsBetween(new CommitsBetweenRequest.Builder(repository).exclude(refChange.getFromHash(), new String[0]).include(refChange.getToHash(), new String[0]).build(), PageUtils.newRequest((int)0, (int)7)).getValues();
        return Iterables.transform((Iterable)commits, this::commitModel);
    }

    private String render(final Map<String, Object> soyData, final String template) {
        return (String)this.securityService.anonymously("Using system locale").call((Operation)new UncheckedOperation<String>(){

            public String perform() {
                try {
                    return HipChatNotificationRenderer.this.soyTemplateRenderer.render(HipChatNotificationRenderer.MODULE_KEY, template, soyData);
                }
                catch (SoyException e) {
                    logger.error("Failed to render hipchat notification message", (Throwable)e);
                    return "";
                }
            }
        });
    }
}

