/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.codeinsights;

import com.atlassian.bitbucket.codeinsights.InsightAnnotation;
import java.util.ArrayList;
import java.util.List;

public class ParseResults {
    private int testsPass;
    private int testsFailed;
    private int testsInError;
    private long totalDuration;
    private int skippedTests;
    private List<InsightAnnotation> annotations = new ArrayList<InsightAnnotation>();

    public ParseResults() {
    }

    public ParseResults(List<ParseResults> toCombine) {
        this();
        toCombine.forEach(result -> {
            this.testsPass += result.testsPass;
            this.testsFailed += result.testsFailed;
            this.testsInError += result.testsInError;
            this.totalDuration += result.totalDuration;
            this.skippedTests += result.skippedTests;
            this.annotations.addAll(result.annotations);
        });
    }

    public void addAnnotations(List<InsightAnnotation> annotations) {
        annotations.addAll(annotations);
    }

    public void addTestsPass() {
        ++this.testsPass;
    }

    public void addTestFail() {
        ++this.testsFailed;
    }

    public void addTestInError() {
        ++this.testsInError;
    }

    public void addToTotalDuration(long delta) {
        this.totalDuration += delta;
    }

    public void addSkippedTests() {
        ++this.skippedTests;
    }

    public void addAnnotation(InsightAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public boolean isEmpty() {
        return this.testsPass == 0 && this.testsFailed == 0 && this.testsInError == 0 && this.annotations.isEmpty() && this.totalDuration == 0L && this.skippedTests == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int getTestsPass() {
        return this.testsPass;
    }

    public int getTestsFailed() {
        return this.testsFailed;
    }

    public int getTestsInError() {
        return this.testsInError;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public int getSkippedTests() {
        return this.skippedTests;
    }

    public List<InsightAnnotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return "ParseResults{testsPass=" + this.testsPass + ", testsFailed=" + this.testsFailed + ", testsInError=" + this.testsInError + ", totalDuration=" + this.totalDuration + ", skippedTests=" + this.skippedTests + ", annotations=" + this.annotations + '}';
    }
}

