package com.atlassian.beehive.simple;

import java.util.Collection;

import javax.annotation.Nonnull;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.core.LockRegistry;
import com.atlassian.beehive.core.ManagedClusterLockService;

/**
 * Simple implementation of ClusterLockService that works for a single node application.
 * <p>
 * Certain cross product libraries (eg SAL and AO) will depend on having an implementation of ClusterLockService, and this one
 * can used by applications that only run as a single node.
 */
public class SimpleClusterLockService implements ManagedClusterLockService
{
    private final LockRegistry<SingleNodeLock> registry = new LockRegistry<SingleNodeLock>()
    {
        @Override
        protected SingleNodeLock createLock(String lockName)
        {
            return new SingleNodeLock(lockName);
        }
    };

    @Override
    public Collection<SingleNodeLock> getAllKnownClusterLocks()
    {
        return registry.getAllKnownClusterLocks();
    }

    @Nonnull
    @Override
    public Collection<ClusterLockStatus> getStatusesOfAllHeldClusterLocks() {
        return registry.getStatusesOfAllHeldClusterLocks();
    }

    @Override
    public ClusterLock getLockForName(@Nonnull String lockName)
    {
        return registry.getLockForName(lockName);
    }
}
