/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.simple;

import com.atlassian.beehive.core.ClusterLockStatus;
import com.atlassian.beehive.core.ManagedClusterLock;
import com.atlassian.beehive.core.stats.StatisticsKey;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;

class SingleNodeLock
implements ManagedClusterLock {
    private final String name;
    private final ReentrantLock lock = new ReentrantLock();
    private static final String NODE_NAME = "single node";

    SingleNodeLock(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }

    public void lockInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    public boolean tryLock() {
        return this.lock.tryLock();
    }

    public boolean tryLock(long timeout, @Nonnull TimeUnit unit) throws InterruptedException {
        return this.lock.tryLock(timeout, unit);
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isHeldByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    @Nonnull
    public Condition newCondition() {
        throw new UnsupportedOperationException("newCondition() not supported in ClusterLock");
    }

    @Nonnull
    public Map<StatisticsKey, Long> getStatistics() {
        int queueLen = this.lock.getQueueLength();
        if (queueLen > 0) {
            return ImmutableMap.of((Object)StatisticsKey.WAIT_QUEUE_LENGTH, (Object)queueLen);
        }
        return ImmutableMap.of();
    }

    @Nonnull
    public ClusterLockStatus getClusterLockStatus() {
        return new ClusterLockStatus(this.getName(), NODE_NAME, 0L);
    }
}

