/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.hazelcast;

import com.hazelcast.core.IMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

class HazelcastMappedLock {
    private final ThreadLocal<Map<String, Integer>> acquiredLocks = new ThreadLocal<Map<String, Integer>>(){

        @Override
        protected Map<String, Integer> initialValue() {
            return new HashMap<String, Integer>();
        }
    };
    private final IMap<String, String> lockMap;

    public HazelcastMappedLock(IMap<String, String> lockMap) {
        this.lockMap = lockMap;
    }

    public boolean isHeldByCurrentThread(String lockName) {
        return this.acquiredLocks.get().containsKey(lockName);
    }

    public void lock(String lockName) {
        this.lockMap.lock((Object)lockName);
        this.onAcquired(lockName);
    }

    public void lockInterruptibly(String lockName) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException("Thread has been interrupted before attempting to acquire lock " + lockName);
        }
        while (!this.lockMap.tryLock((Object)lockName, 1L, TimeUnit.DAYS)) {
        }
        this.onAcquired(lockName);
    }

    public boolean tryLock(String lockName) {
        if (this.lockMap.tryLock((Object)lockName)) {
            this.onAcquired(lockName);
            return true;
        }
        return false;
    }

    public boolean tryLock(String lockName, long time, TimeUnit unit) throws InterruptedException {
        if (this.lockMap.tryLock((Object)lockName, time, unit)) {
            this.onAcquired(lockName);
            return true;
        }
        return false;
    }

    public void unlock(String lockName) {
        this.lockMap.unlock((Object)lockName);
        this.onRelease(lockName);
    }

    private void onAcquired(String lockName) {
        Map<String, Integer> map;
        Integer count = (map = this.acquiredLocks.get()).get(lockName);
        map.put(lockName, count == null ? 1 : count + 1);
    }

    private void onRelease(String lockName) {
        Map<String, Integer> map = this.acquiredLocks.get();
        Integer count = map.get(lockName);
        if (count == null) {
            throw new IllegalStateException("Lock " + lockName + " wasn't held prior to unlock being called!");
        }
        if (count == 1) {
            map.remove(lockName);
        } else {
            map.put(lockName, count - 1);
        }
    }
}

