package com.atlassian.beehive.db;

import java.time.Duration;

public class LockExpiryConfiguration {

    public static final String RENEWAL_INTERVAL_PERIOD_SECONDS_KEY = "beehive.lease.renewal.period.seconds";
    public static final String EXPIRY_PERIOD_DURATION_SECONDS_KEY = "beehive.lease.duration.seconds";

    private static final long DEFAULT_RENEWAL_INTERVAL_PERIOD_SECONDS = 5L;
    private static final long DEFAULT_EXPIRY_PERIOD_DURATION_SECONDS = Duration.ofMinutes(5).getSeconds();

    private static final long renewalIntervalPeriodSeconds = Long.getLong(RENEWAL_INTERVAL_PERIOD_SECONDS_KEY, DEFAULT_RENEWAL_INTERVAL_PERIOD_SECONDS);
    private static final long expiryPeriodDurationSeconds = Long.getLong(EXPIRY_PERIOD_DURATION_SECONDS_KEY, DEFAULT_EXPIRY_PERIOD_DURATION_SECONDS);

    /**
     * A amount of time since the last confirmation of lock state, during which lock should be treated as fully owned by the reported owner.
     * Defaults to 5, can be overriden by system property <code>beehive.lease.duration.seconds</code>. Should never be smaller than value returned by {@link LockExpiryConfiguration#getRenewalIntervalInSeconds()}.
     *
     * @return An amount of time since the last confirmation of lock state, during which lock should be treated as fully owned by the reported owner.
     */
    public static long getExpiryPeriodDurationSeconds() {
        return expiryPeriodDurationSeconds;
    }

    /**
     * Time between periodical renewals of lease for all locks owned by this instance.
     * Defaults to 300, Can be overriden by system property beehive.lease.renewal.interval.seconds. Should never be larger than value returned by{@link LockExpiryConfiguration#getExpiryPeriodDurationSeconds()}.
     *
     * @return Time between renewals of lease for all locks owned by this instance
     */
    public static long getRenewalIntervalInSeconds() {
        return renewalIntervalPeriodSeconds;
    }
}
