/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.db;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.db.DatabaseClusterLock;
import com.atlassian.beehive.db.DeadOwnerThreadException;
import com.atlassian.beehive.db.LockExpiryConfiguration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DatabaseClusterLockLeaseRenewer {
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, runnable -> {
        Thread t = new Thread(runnable, "cluster-lock-lease-renewal-thread");
        t.setDaemon(true);
        return t;
    });
    private final ConcurrentHashMap<String, RenewalInstance> renewerMap;
    private static final Logger log = LoggerFactory.getLogger(DatabaseClusterLockLeaseRenewer.class);

    DatabaseClusterLockLeaseRenewer() {
        this.executor.setRemoveOnCancelPolicy(true);
        this.renewerMap = new ConcurrentHashMap();
    }

    void onLock(DatabaseClusterLock lock) {
        log.trace("onLock: " + lock.getName());
        RenewalTask task = this.createRenewalTask(lock);
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(task, 5000L, LockExpiryConfiguration.getRenewalIntervalInSeconds() * 1000L, TimeUnit.MILLISECONDS);
        RenewalInstance previous = this.renewerMap.put(lock.getName(), new RenewalInstance(task, future));
        if (previous != null) {
            log.warn("Detected previous, unfinished job when scheduling new renewer job for " + lock.getName() + ", cancelling old job...");
            previous.getFuture().cancel(true);
        }
    }

    void onUnlock(DatabaseClusterLock lock) {
        log.trace("onUnlock: " + lock.getName());
        this.unscheduleForLock(lock.getName());
    }

    void shutdown() {
        this.executor.shutdownNow();
    }

    @VisibleForTesting
    RenewalTask createRenewalTask(DatabaseClusterLock lock) {
        return new RenewalTask(lock);
    }

    private void unscheduleForLock(String lockName) {
        RenewalInstance renewal = this.renewerMap.remove(lockName);
        if (renewal != null) {
            renewal.getFuture().cancel(true);
        }
    }

    private void unscheduleTask(RenewalTask task) {
        Predicate<Map.Entry> entryPredicate = e -> task.equals(((RenewalInstance)e.getValue()).getTask());
        this.renewerMap.entrySet().stream().filter(entryPredicate).findFirst().map(Map.Entry::getValue).map(RenewalInstance::getFuture).ifPresent(f -> f.cancel(false));
        this.renewerMap.entrySet().removeIf(entryPredicate);
    }

    class RenewalTask
    implements Runnable {
        private final DatabaseClusterLock lock;
        private final Long startedAt = System.currentTimeMillis();

        public RenewalTask(DatabaseClusterLock lock) {
            this.lock = lock;
        }

        @Override
        public void run() {
            try {
                log.trace("Renewing lease on lock: " + this.getLockName());
                if (this.lock.renew()) {
                    log.trace("Successfully renewed lease on lock: {}, held for {} ", (Object)this.getLockName(), (Object)(System.currentTimeMillis() - this.startedAt));
                }
            }
            catch (DeadOwnerThreadException e) {
                log.warn("Detected that lock {} is owned by a dead thread. Canceling renewer process for this lock...", (Object)this.getLockName());
                this.unscheduleSelf();
            }
            catch (Throwable t) {
                log.error("Failed to renew lease on lock: , " + this.getLockName() + ". Error occured during attempt to renew this lock. This should never happen here. Will retry on next scheduled run...", t);
            }
        }

        private void unscheduleSelf() {
            DatabaseClusterLockLeaseRenewer.this.unscheduleTask(this);
        }

        private String getLockName() {
            return this.lock.getName();
        }
    }

    private static class RenewalInstance {
        private RenewalTask task;
        private ScheduledFuture future;

        public RenewalInstance(RenewalTask task, ScheduledFuture future) {
            this.task = task;
            this.future = future;
        }

        public RenewalTask getTask() {
            return this.task;
        }

        public ScheduledFuture getFuture() {
            return this.future;
        }
    }
}

